import {
  BRAND_LOGO,
  BRAND_LOGO_DARK,
  BRAND_LOGO_ROUNDED,
} from "constants/config";

/* eslint-disable @next/next/no-img-element */
export const BrandLogo = () => (
  <img src={BRAND_LOGO} width="129" height="28" alt="Brand logo" />
);

export const BrandLogoDark = () => (
  <img src={BRAND_LOGO_DARK} width="129" height="28" alt="Brand logo dark" />
);

export const DoubleCheckIcon = () => (
  <svg
    width="30"
    height="30"
    viewBox="0 0 30 30"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <circle cx="15" cy="15" r="15" fill="#83EA00" />
    <g clipPath="url(#clip0_109_101)">
      <path
        d="M14.668 16.4666L15.8447 17.6433L22.8997 10.5883L24.078 11.7666L15.8447 19.9999L10.5413 14.6966L11.7197 13.5183L13.4905 15.2891L14.668 16.4658V16.4666ZM14.6697 14.1099L18.7963 9.98242L19.9713 11.1574L15.8447 15.2849L14.6697 14.1099ZM12.3138 18.8224L11.1363 19.9999L5.83301 14.6966L7.01134 13.5183L8.18884 14.6958L8.18801 14.6966L12.3138 18.8224Z"
        fill="black"
      />
    </g>
    <defs>
      <clipPath id="clip0_109_101">
        <rect width="20" height="20" fill="white" transform="translate(5 5)" />
      </clipPath>
    </defs>
  </svg>
);

export const BrandLogoRounded = () => (
  <img
    src={BRAND_LOGO_ROUNDED}
    width="60"
    height="60"
    alt="Brand logo rounded"
  />
);

export const EveryDay = () => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M11.0046 11.9192C12.5233 11.9192 13.7546 13.1505 13.7546 14.6692C13.7546 15.4477 13.4312 16.1505 12.9114 16.6508L11.1605 18.3355L13.7546 18.3359V20.1692H8.25456L8.25373 18.5885L11.6402 15.3298C11.8135 15.1628 11.9212 14.9286 11.9212 14.6692C11.9212 14.163 11.5109 13.7526 11.0046 13.7526C10.4983 13.7526 10.0879 14.163 10.0879 14.6692H8.25456C8.25456 13.1505 9.48575 11.9192 11.0046 11.9192ZM16.5046 11.9192V15.5859H18.3379V11.9192H20.1712V20.1692H18.3379V17.4192H14.6712V11.9192H16.5046ZM3.67122 11.0026C3.67122 13.3186 4.74486 15.3839 6.42158 16.7278L6.42124 18.9429C3.68131 17.358 1.83789 14.3955 1.83789 11.0026H3.67122ZM11.0046 1.83594C15.7578 1.83594 19.666 5.45367 20.126 10.0858L18.2812 10.086C17.8301 6.46851 14.7442 3.66927 11.0046 3.66927C8.48393 3.66927 6.26032 4.941 4.94037 6.87782L7.33789 6.8776V8.71094H1.83789V3.21094H3.67122L3.67112 5.50185C5.34354 3.27579 8.0059 1.83594 11.0046 1.83594Z"
      fill="white"
    />
  </svg>
);

export const Gift = () => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M13.2962 1.83594C15.0682 1.83594 16.5046 3.27235 16.5046 5.04427C16.5046 5.53671 16.3937 6.00324 16.1954 6.42022L19.2546 6.41927C19.7609 6.41927 20.1712 6.82967 20.1712 7.33594V11.0026C20.1712 11.5089 19.7609 11.9192 19.2546 11.9192H18.3379V19.2526C18.3379 19.7589 17.9275 20.1692 17.4212 20.1692H4.58789C4.08163 20.1692 3.67122 19.7589 3.67122 19.2526V11.9192H2.75456C2.2483 11.9192 1.83789 11.5089 1.83789 11.0026V7.33594C1.83789 6.82967 2.2483 6.41927 2.75456 6.41927L5.81376 6.42022C5.6155 6.00324 5.50456 5.53671 5.50456 5.04427C5.50456 3.27235 6.94098 1.83594 8.71289 1.83594C9.61124 1.83594 10.4233 2.20513 11.0057 2.80007C11.5858 2.20513 12.3979 1.83594 13.2962 1.83594ZM16.5046 11.9192H5.50456V18.3359H16.5046V11.9192ZM18.3379 8.2526H3.67122V10.0859H18.3379V8.2526ZM8.71289 3.66927C7.95351 3.66927 7.33789 4.28488 7.33789 5.04427C7.33789 5.759 7.88321 6.34635 8.58047 6.41297L8.71289 6.41927H10.0879V5.04427C10.0879 4.32955 9.54258 3.74219 8.84531 3.67557L8.71289 3.66927ZM13.2962 3.66927L13.1638 3.67557C12.5101 3.73803 11.99 4.25817 11.9275 4.91185L11.9212 5.04427V6.41927H13.2962L13.4286 6.41297C14.1259 6.34635 14.6712 5.759 14.6712 5.04427C14.6712 4.32955 14.1259 3.74219 13.4286 3.67557L13.2962 3.66927Z"
      fill="white"
    />
  </svg>
);

export const Flash = () => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M11.917 9.16675H18.3337L10.0837 21.0834V12.8334H3.66699L11.917 0.916748V9.16675Z"
      fill="white"
    />
  </svg>
);

export const PickupFromIcon = () => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M5.04208 18.3338C5.80147 18.3338 6.41708 18.9493 6.41708 19.7088C6.41708 20.4682 5.80147 21.0838 5.04208 21.0838C4.28269 21.0838 3.66708 20.4682 3.66708 19.7088C3.66708 18.9493 4.28269 18.3338 5.04208 18.3338ZM16.9588 18.3338C17.7182 18.3338 18.3338 18.9493 18.3338 19.7088C18.3338 20.4682 17.7182 21.0838 16.9588 21.0838C16.1993 21.0838 15.5838 20.4682 15.5838 19.7088C15.5838 18.9493 16.1993 18.3338 16.9588 18.3338ZM1.99103 1.61133L5.49983 5.12033V15.5832L18.3338 15.5838V17.4171H4.58375C4.07749 17.4171 3.66708 17.0066 3.66708 16.5005L3.66649 5.87933L0.69466 2.9077L1.99103 1.61133ZM14.6671 2.75041C15.1733 2.75041 15.5838 3.16082 15.5838 3.66708L15.5831 5.49983L18.3275 5.50041C18.8372 5.50041 19.2505 5.91811 19.2505 6.41286V13.7547C19.2505 14.2586 18.838 14.6671 18.3275 14.6671H7.34002C6.83029 14.6671 6.41708 14.2494 6.41708 13.7547V6.41286C6.41708 5.90894 6.82953 5.50041 7.34002 5.50041L10.0831 5.49983L10.0838 3.66708C10.0838 3.16082 10.4942 2.75041 11.0005 2.75041H14.6671ZM9.16649 7.33316L8.25041 7.33375V12.8338L9.16649 12.8332V7.33316ZM14.6665 7.33316H10.9998V12.8332H14.6665V7.33316ZM17.4171 7.33375L16.4998 7.33316V12.8332L17.4171 12.8338V7.33375ZM13.7505 4.58375H11.9171V5.50041H13.7505V4.58375Z"
      fill="black"
    />
  </svg>
);

export const DeliveryIcon = () => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="18"
    height="18"
    viewBox="0 0 18 18"
    fill="none"
  >
    <path
      d="M3.07795 10.6919H0.899951C0.647951 10.6919 0.449951 10.8899 0.449951 11.1419C0.449951 11.3939 0.647951 11.5919 0.899951 11.5919H3.07795C3.32995 11.5919 3.52795 11.3939 3.52795 11.1419C3.52795 10.8899 3.32995 10.6919 3.07795 10.6919Z"
      fill="black"
    />
    <path
      d="M3.07806 9.01782H1.45806C1.20606 9.01782 1.00806 9.21582 1.00806 9.46782C1.00806 9.71982 1.20606 9.91782 1.45806 9.91782H3.09606C3.34806 9.91782 3.54606 9.71982 3.54606 9.46782C3.52806 9.21582 3.33006 9.01782 3.07806 9.01782Z"
      fill="black"
    />
    <path
      d="M3.07785 7.36206H1.99785C1.74585 7.36206 1.54785 7.56006 1.54785 7.81206C1.54785 8.06406 1.74585 8.26206 1.99785 8.26206H3.07785C3.32985 8.26206 3.52785 8.06406 3.52785 7.81206C3.52785 7.56006 3.32985 7.36206 3.07785 7.36206Z"
      fill="black"
    />
    <path
      d="M16.542 9.01792L15.462 8.83792L14.814 6.89392C14.652 6.40792 14.184 6.06592 13.68 6.06592H9.37798C9.37798 6.37192 9.32398 6.67792 9.23398 6.96592H11.628V9.23392C11.628 9.48592 11.826 9.68392 12.078 9.68392H15.084L16.398 9.89992C16.542 9.91792 16.65 10.0439 16.65 10.1879V11.6279C16.65 11.7899 16.524 11.9339 16.344 11.9339H15.912C15.642 11.3939 15.102 11.0339 14.454 11.0339C13.824 11.0339 13.266 11.4119 12.996 11.9339H8.98198C8.71198 11.3939 8.17198 11.0339 7.52398 11.0339C6.89398 11.0339 6.33598 11.4119 6.06598 11.9339H5.63398C5.47198 11.9339 5.32798 11.8079 5.32798 11.6279V9.01792C5.00398 8.92792 4.69798 8.76592 4.42798 8.56792V11.6459C4.42798 12.3119 4.96798 12.8519 5.63398 12.8519H5.90398C5.99398 13.6619 6.67798 14.2919 7.52398 14.2919C8.36998 14.2919 9.05398 13.6619 9.14398 12.8519H12.834C12.924 13.6619 13.608 14.2919 14.454 14.2919C15.282 14.2919 15.984 13.6619 16.074 12.8519H16.362C17.028 12.8519 17.568 12.3119 17.568 11.6459V10.2059C17.55 9.61192 17.118 9.10792 16.542 9.01792ZM12.528 8.78392V6.98392H13.68C13.806 6.98392 13.932 7.07392 13.968 7.18192L14.508 8.78392H12.528ZM7.52398 13.3919C7.12798 13.3919 6.80398 13.0679 6.80398 12.6719C6.80398 12.2759 7.12798 11.9519 7.52398 11.9519C7.91998 11.9519 8.24398 12.2759 8.24398 12.6719C8.24398 13.0679 7.93798 13.3919 7.52398 13.3919ZM14.454 13.3919C14.058 13.3919 13.734 13.0679 13.734 12.6719C13.734 12.2759 14.058 11.9519 14.454 11.9519C14.85 11.9519 15.174 12.2759 15.174 12.6719C15.174 13.0679 14.85 13.3919 14.454 13.3919Z"
      fill="black"
    />
    <path
      d="M6.24607 8.33394C7.52407 8.33394 8.56807 7.28994 8.56807 6.01194C8.56807 4.73394 7.52407 3.68994 6.24607 3.68994C4.96807 3.68994 3.92407 4.73394 3.92407 6.01194C3.92407 7.28994 4.96807 8.33394 6.24607 8.33394ZM5.88607 4.80594C5.88607 4.60794 6.04807 4.44594 6.24607 4.44594C6.44407 4.44594 6.60607 4.60794 6.60607 4.80594V5.65194H7.14607C7.34407 5.65194 7.50607 5.81394 7.50607 6.01194C7.50607 6.20994 7.34407 6.37194 7.14607 6.37194H6.26407C6.06607 6.37194 5.90407 6.20994 5.90407 6.01194V4.80594H5.88607Z"
      fill="black"
    />
  </svg>
);

export const BoxLineIcon = () => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M10.5416 0.916626L19.25 5.95829V16.0416L10.5416 21.0833L1.83331 16.0416V5.95829L10.5416 0.916626ZM4.5777 6.48785L10.5417 9.94066L16.5057 6.48789L10.5416 3.03504L4.5777 6.48785ZM3.66665 8.07881V14.9846L9.62507 18.4342V11.5284L3.66665 8.07881ZM11.4584 18.4341L17.4166 14.9846V8.07888L11.4584 11.5284V18.4341Z"
      fill="black"
    />
  </svg>
);

export const VerifiedIcon = () => (
  <svg
    viewBox="0 0 24 24"
    aria-hidden="true"
    data-testid="verificationBadge"
    version="1.1"
    id="svg965"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
  >
    {/* <defs id="defs969" /> */}
    <g id="g963">
      <path
        d="M22.25 12c0-1.43-.88-2.67-2.19-3.34.46-1.39.2-2.9-.81-3.91s-2.52-1.27-3.91-.81c-.66-1.31-1.91-2.19-3.34-2.19s-2.67.88-3.33 2.19c-1.4-.46-2.91-.2-3.92.81s-1.26 2.52-.8 3.91c-1.31.67-2.2 1.91-2.2 3.34s.89 2.67 2.2 3.34c-.46 1.39-.21 2.9.8 3.91s2.52 1.26 3.91.81c.67 1.31 1.91 2.19 3.34 2.19s2.68-.88 3.34-2.19c1.39.45 2.9.2 3.91-.81s1.27-2.52.81-3.91c1.31-.67 2.19-1.91 2.19-3.34zm-11.71 4.2L6.8 12.46l1.41-1.42 2.26 2.26 4.8-5.23 1.47 1.36-6.2 6.77z"
        id="path961"
        fill="#42A5F5"
      />
    </g>
  </svg>
);
